#version 330
#extension GL_EXT_gpu_shader4 : enable
//camera controlMod01.fsh  by rickiters
//https://www.shadertoy.com/view/4dBSRd
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.354 //0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//// input
// keys
const int kA=65,kB=66,kC=67,kD=68,kE=69,kF=70,kG=71,kH=72,kI=73,kJ=74,kK=75,kL=76,kM=77;
const int kN=78,kO=79,kP=80,kQ=81,kR=82,kS=83,kT=84,kU=85,kV=86,kW=87,kX=88,kY=89,kZ=90;
const int k0=48,k1=49,k2=50,k3=51,k4=52,k5=53,k6=54,k7=55,k8=56,k9=57;
const int kSpace=32,kLeft=37,kUp=38,kRight=39,kDown=40;


// TOGGLES:
int kRed = k1;
int kGreen = k2;
int kBlue = k3;

float lodBias = -2.2;
float time = 0.;

float PI = 3.14159;

// key is javascript keycode: http://www.webonweboff.com/tips/js/event_key_codes.aspx
bool ReadKeyBool( int key, bool toggle )
{
	float keyVal = texture( iChannel3, vec2( (float(key)+.5)/256.0, toggle?.75:.25 ) ).x;
	return (keyVal>.5)?true:false;
}

float ReadKeyFloat( int key, bool toggle )
{
	float keyVal = texture( iChannel3, vec2( (float(key)+.5)/256.0, toggle?.75:.25 ) ).x;
	return step(.5,keyVal);
}


//// convert screen coords to -asp to +asp for x, -1 to +1 for y, asp = aspect ratio
// normalized device coords
vec2 ndc(vec2 p)
{
    p *= 2.0/iResolution.y;
    p += vec2(-iResolution.x/iResolution.y,-1.0);
	return p;
}
/*
//// convert screen coords to -1 to +1 for x, -1 to +1 for y, asp = assumed to be 1.0
// normalized device coords
vec2 ndc_noasp(vec2 p)
{
    p *= vec2(2.0/iResolution.x,2.0/iResolution.y);
    p += -1.;
	return p;
}
*/
// generate a 2d rotation matrix
mat2 rot(float a) {
	return mat2(cos(a),sin(a),-sin(a),cos(a));	
}

//const vec3 background  = vec3(0.0, 0.0, 0.2);
const vec3 light_1     = vec3(4.0, 8.0,  3.0);
const vec3 light_2     = vec3(-4.0, 8.0, -7.0);
//const vec2 eps         = vec2(0.001, 0.0);
//const int maxSteps     = 64;

// some lighting
vec3 shade(vec3 color, vec3 point, vec3 normal,vec3 rd)
{
	
	vec3 dtl       = normalize(light_1 - point);
	float diffuse  = dot(dtl, normal); //diffuse
	float specular = 0.75 * pow(max(dot(reflect(dtl, normal), rd), 0.0), 64.0); //specular
	vec3 c = (diffuse + specular) * color * 0.85;
	
	dtl      =  normalize(light_2 - point);
	diffuse  = dot(dtl, normal); //more diffuse
	specular = 0.9 * pow(max(dot(reflect(dtl, normal), rd), 0.0), 128.0); //more specular
	return clamp( c + (diffuse + specular) * 0.25 * color, 0.0, 1.0);
}



//// raytrace plane
// return color of plane at xyz, this plane is at y = 0
vec3 planeColor(vec3 loc,bool pc)
{
    loc *= 10.;
    vec2 loct = loc.xz * vec2(.1,-.1);
    vec3 ret3 = texture(iChannel2,loct,lodBias).xyz;
    if (pc) {
        if (loc.x >= 0.0)
        	ret3.r += .25;
    	if (loc.z >= 0.0)
        	ret3.b += .25;
        if (fract(loc.x*.05) >= .5)
            ret3.r -= .15;
        if (fract(loc.z*.05) >= .5)
            ret3.g -= .15;
	    vec2 loc2 = loct;
        if (fract(loc2.x*.05) >= .5)
            ret3.b -= .45;
        if (fract(loc2.y*.05) >= .5)
            ret3.g -= .45;
    }
	return ret3;
}


//// sky and plane
vec3 skyPlane(vec3 rs,vec3 rd,bool planeaxis) // unnormalized direction
{
// sky color
    vec3 skycolor = vec3(0.0,0.0,1.0) - vec3(0.0,0.0,rd.y);
    
    // plane color
    float t = -rs.y/rd.y;
    vec3 isect = rs + rd*t;
    vec3 planecolor = planeColor(isect,planeaxis);
    
    vec3 skyplanecolor;
    if (rd.y >= 0.0)
        skyplanecolor = skycolor;
    else
        skyplanecolor = planecolor;
    return skyplanecolor;
}


//// raymarch
vec3 sceneCol;

float sdSphere(vec3 p,float r)
{
	return length(p)-r;
}

float sdBox(vec3 p,vec3 b)
{
	vec3 d = abs(p) - b;
  	return min(max(d.x,max(d.y,d.z)),0.0) + length(max(d,0.0));
}

float sdTorus(vec3 p,vec2 t)
{
	vec2 q = vec2(length(p.xz)-t.x,p.y);
	return length(q)-t.y;
}

// h.x = radius h.y = height
float sdCappedCylinder(vec3 p,vec2 h)
{
  vec2 d = abs(vec2(length(p.xz),p.y)) - h;
  return min(max(d.x,d.y),0.0) + length(max(d,0.0));
}

// c.xy is the position if xz, c.z is the radius
float sdCylinder( vec3 p, vec3 c )
{
  return length(p.xz-c.xy)-c.z;
}

// n.w is the distance from origin to the plane P*N = D
float sdPlane(vec3 p,vec4 n)
{
  // n.xyz must be normalized
  return dot(p,n.xyz) + n.w;
}

// CSG Union d1 U d2
float opU(float d1,float d2)
{
    return min(d1,d2);
}

// CSG Intersection d1 ^ d2
float opI(float d1,float d2)
{
    return max(d1,d2);
}

// CSG Subtract d1 - d2
float opS(float d1,float d2)
{
    return max(d1,-d2);
}

float scene1(vec3 pr)
{
    //vec3 pr = p;
    //pr.x += 4.0;
    //pr.xy *= rot(iTime*.5);
    pr.xz *= rot(1.57);
    sceneCol = fract(pr*8.0);
    float d1 = sdBox(pr,vec3(.5,1.0,1.5));
    //float d1 = sdBox(pr,vec3(.25,.5,.75));
    //float d2 = sdSphere(p,1.0); // p or pr, it's a sphere
    pr.xy *= rot(1.57);
	float d2 = sdCappedCylinder(pr,vec2(.50,12));
    //float d3 = sdTorus(pr,vec2(1.0,.25));
    //float d4 = sdCappedCylinder(pr,vec2(.25,1.0));
    //return opU(d1,d2);
    //return opI(d1,d2);
    return opS(d1,d2);
    //return opS(d2,d1);
    //return d1;
    //return d2;
    //return d3;
    //return d4;
}

float opRep_scene1(vec3 p,vec3 c)
{
    vec3 q;
	q = mod(p+.5*c,c)-.5*c;
    return scene1(q);
}

float opRepLimit_scene1(vec3 p,vec3 c,vec3 lim)
{
    vec3 q;
	q = min(p,mod(p+.5*c,c)-.5*c); // less than 0
    q = max(q,p-(lim-vec3(1.0))*c); // more than limit
    return scene1(q);
}

float sceneT(vec3 p)
{
	vec3 pr = p;
    pr.xy *= rot(iTime*.8);    //vec3 pr = 
    pr.yz *= rot(iTime*.7);    //vec3 pr = 
    float d4 = sdTorus(pr,vec2(.125,.03125));
    return d4;
}

float opRep_sceneT(vec3 p,vec3 c)
{
    vec3 q;
	q = mod(p+.5*c,c)-.5*c;
    return sceneT(q);
}

float opRepLimit_sceneT(vec3 p,vec3 c,vec3 lim)
{
    vec3 q;
	q = min(p,mod(p+.5*c,c)-.5*c); // less than 0
    q = max(q,p-(lim-vec3(1.0))*c); // more than limit
    return sceneT(q);
}

float opRepLimitCenter_scene1(vec3 p,vec3 c,vec3 lim)
{
    vec3 lm1 = lim-vec3(1.0);
    p += c*.5*lm1;
    vec3 q;
	q = min(p,mod(p+.5*c,c)-.5*c); // less than 0
    q = max(q,p-(lim-vec3(1.0))*c); // more than limit
    return scene1(q);
}

float opRepLimitCenter_sceneT(vec3 p,vec3 c,vec3 lim)
{
    vec3 lm1 = lim-vec3(1.0);
    p += c*.5*lm1;
    vec3 q;
	q = min(p,mod(p+.5*c,c)-.5*c); // less than 0
    q = max(q,p-(lim-vec3(1.0))*c); // more than limit
    return sceneT(q);
}

float scene2(vec3 p)
{
	return opRep_scene1(p,vec3(10.0));
}

vec3 deform_torus(vec3 p)
{
    float d = p.y + 1.1*sin(5.0*atan(p.z,p.x));
    vec3 pr = vec3(p.x,d,p.z);
    return pr;
}

float scene4(vec3 p)
{
	float rs1 = opRepLimitCenter_scene1(p,vec3(5.0),vec3(9.0));
    //float pn = sdPlane(p,vec4(0.0,0.0,-1.0,10.0));
    //float pn = sdPlane(p,vec4(.7071,0.,-.7071,7.071));
    p.y -= 1.9;
    vec3 pd = deform_torus(p);
	//float tor0 = sdTorus(pd,vec2(8.5,.1));
	float tor1 = sdTorus(pd,vec2(9.5,.1));
	float tor2 = sdTorus(pd,vec2(10.5,.1));
	//float tor3 = sdTorus(pd,vec2(11.5,.1));
    //float tor = opU(opU(opU(tor0,tor1),tor2),tor3);
    float tor = opU(tor1,tor2);
    //return opU(rs1,pn);
    return opU(rs1,tor);
}

float scene5(vec3 p)
{
    vec3 torusmove = vec3(0.);//.7*sin(vec3(iTime,iTime*1.1,iTime*1.3));
    //float d3 = sdSphere(p + vec3(-1,-.75,1.0),.25); // p or pr, it's a sphere
    float d3 = sdSphere(p + vec3(0.,0.,5.),.25); // p or pr, it's a sphere
    float d3_2 = sdSphere(p + vec3(-1.,0.,4.),.25); // p or pr, it's a sphere
    float d3_3 = sdSphere(p + vec3(-2.,0.,3.),.25); // p or pr, it's a sphere
    float c0 = sdSphere(p + vec3(-10.,0.,-10.),.5); // p or pr, it's a sphere
    float c1 = sdSphere(p + vec3(10.,0.,-10.),.5); // p or pr, it's a sphere
    float c2 = sdSphere(p + vec3(-10.,0.,10.),.5); // p or pr, it's a sphere
    float c3 = sdSphere(p + vec3(10.,0.,10.),.5); // p or pr, it's a sphere
    d3 = opU(opU(opU(opU(c0,c1),c2),c3),d3);
    d3 = opU(d3_3,opU(d3,d3_2));
    vec3 pr;
    pr.xz = p.xz * rot(1.57);
    pr.y = p.y;
    sceneCol = fract(pr*8.0);
    float d1 = sdBox(pr,vec3(.5,1.0,1.5));
    pr.xy *= rot(1.57);
    // +Y+Z+X
	float d2 = sdCappedCylinder(pr,vec2(.50,12));
    pr -= vec3(1.,0.,0.)+torusmove;
    //pr.xy *= rot(iTime*.2);
   	//pr.xz *= rot(iTime*.5);
    //float d4 = sdTorus(pr,vec2(.5,.125));
    //float d4 = opRep_sceneT(pr,vec3(1.));
    float d4 = opRepLimitCenter_sceneT(pr,vec3(1.),vec3(2.0,3.0,4.0));
//    float d4 = sdTorus(pr + vec3(-.75,-1.5,-1.0)+vec3(0.0,torusmove,0.0),vec2(.5,.125));
    return opU(d3,opU(d4,opS(d1,d2)));
    //return sdCylinder(pr,vec3(1.0));
}

float scenerails(vec3 p)
{
    p.y -=1.9;
    vec3 pd = deform_torus(p);
	//float tor0 = sdTorus(pd,vec2(8.5,.1));
	float tor1 = sdTorus(pd,vec2(9.5,.1));
	float tor2 = sdTorus(pd,vec2(10.5,.1));
	//float tor3 = sdTorus(pd,vec2(11.5,.1));
    //float tors = opU(opU(opU(tor0,tor1),tor2),tor3);
    float tors = opU(tor1,tor2);
    return tors;
}

float scenetunnel(vec3 p)
{
    vec3 pbox = vec3(p.x-20.,p.y,p.z+20.);
    vec3 ptor = vec3(p.x,p.y-3.1,p.z);
	vec3 pd = deform_torus(ptor);
	float dtorm = sdTorus(pd,vec2(10.,1.5));
	float db = sdBox(pbox,vec3(20.));
    float d = opS(db,dtorm);
    //float d = dtorm;
    //float d = dtorm;
    return d;
}

float scene(vec3 p)
{
	//float d = scene1(p);
    //float d = scene2(p);
    float d4 = scene4(p);
    float d5 = scene5(p);
    float d45 = opU(d4,d5);
    float dtunnel = scenetunnel(p);
    float drails = scenerails(p);
    float d = opU(opU(d45,drails),dtunnel);
    //float d = opU(d45,drails);
    return d;
}

vec3 getNormal(vec3 p)
{
    const float eps = .001;
    float d0x = scene(vec3(p.x - eps,p.yz));
    float d1x = scene(vec3(p.x + eps,p.yz));
    float d0y = scene(vec3(p.x,p.y - eps,p.z));
    float d1y = scene(vec3(p.x,p.y + eps,p.z));
    float d0z = scene(vec3(p.xy,p.z - eps));
    float d1z = scene(vec3(p.xy,p.z + eps));
    //return vec3(d1x-d0x,d1y-d0y,d1z-d0z)*(.5/eps);
    //return normalize(vec3(d1x-d0x,d1y-d0y,d1z-d0z)*(2.5/eps));
    return normalize(vec3(d1x-d0x,d1y-d0y,d1z-d0z));
    //return vec3(1.0,0.0,0.0);
}
    
vec3 getTex(vec3 p)
{
	p = fract(p);
    //p.xy *= rot(iTime*.5);
    //p.xz *= rot(iTime*.25);
    return p;
    //return vec3(1.0);
}
    
/*float getNormalZ(vec3 p)
{
    const float eps = .0001;
    float d0z = scene(vec3(p.xy,p.z + eps));
    float d1z = scene(vec3(p.xy,p.z - eps));
    //return (d1 - d0)/eps;
    return (d1z-d0z)/eps;
}
*/  

// very simple ambient occlusion
float getAO(vec3 rs,vec3 rd)
{
    // move away along the normal
    float d = .3;
    float k = 1.0;
    float ret = 1.0;
    for (int i = 1;i<5;++i) {
        float fi = float(i);
        k *= .5;
        float distBack = scene(rs + rd*(d*fi));
        ret -= k*(fi*d - distBack);
    }
    return ret;
    //return 1.0;
    //return distBack/k;
    //return k/distBack;
}

vec3 march(vec3 rs,vec3 rd,out bool hit)
{
    const float conserve = .87;//1.0; // .87; // compensate for errors in distance function esp. rotate box repeat
    const int steps = 180;
    float eps = .001;
    float toobig = 1000.0;
	vec3 col = vec3(0.0,0.0,0.0);
    hit = false;
    for (int i=0;i<steps;++i) {
        float d = scene(rs);
        if (d > toobig) { // bail early if clearly can't hit anything
            hit = false;
            break;
        }
        if (d < eps) {
            //if (true) {
            if (rs.y >= 0.0) { // hit above ground
                vec3 norm = getNormal(rs);
 				// normal color, very simple lighting .5 ambient, .5 directional
 				// normal in opposite direction of light gets the light
                //col += max(-norm.x,0.0)*.5+.5; // dir +1x
                //col += max(norm.y,0.0)*.5+.5; // dir -1y
                //col += max(-norm.z,0.0)*.5+.5; // dir +1z
                //col += -norm.z; // dir +1z, no ambient all directional
                col += shade(vec3(1.),rs,norm,rd)*.9;
				col += sceneCol*.1;
                //col += getTex(rs); // texture color
                //col += norm*.5 + vec3(.5); // normal color 0 to 1
                //col += norm; // raw normal color -1 to 1
    			//col += float(i)*(10.0/256.0); // brighter if more iterations
                float ao = getAO(rs,norm);
                col *= ao;
                hit = true;
            }
            break;
        }
        rs += rd*d*conserve; // compensate for the slight error from rotating boxes distance modulo function
    }

    return col;
}


//// main
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    float time = iTime*.2;
    //bool roll = ReadKeyBool(k1,true);
    bool planeaxis = !ReadKeyBool(k2,true);
    bool movexy = ReadKeyBool(k3,true);

    // ndc
    vec2 pos = ndc(gl_FragCoord.xy); // -asp to +asp for x, -1 to +1 for y
    vec2 mouse;// = vec2(0.0,0.0);
    
    // if (iMouse.x == 0.0 && iMouse.y == 0.0) // hack for mouse not yet clicked
    if (iMouse.x == 0.0 ) // hack for mouse not yet clicked
        mouse = vec2(0.0,0.0);
    else
    	mouse = ndc(iMouse.xy);
    	//mouse = ndc(iMouse.xy);
    // keyboard color, for circle (press 1,2,3)
    vec3 keycolor = vec3(ReadKeyFloat(kRed,true),
             ReadKeyFloat(kGreen,true),
             ReadKeyFloat(kBlue,true));
    
    //// camera
    const float zoom = 2.0; // about 53 degrees vertical
    //const float zoom = 1.0; // exactly 90 degrees vertical
    // make a ray, left handed coords
    
    // ray source
    float k = PI*2./15.;
    float m = 5. * k;
    float rad = 10.;
    float angy = k * time; 
    float angm = m *time;
    vec2 posxz = vec2(rad*cos(angy),rad*sin(angy));
    float medy = 2.4;
    float ampy = 1.1;
    float rsy = medy + -ampy*sin(angm);
    vec3 rs = vec3(posxz.x,rsy,posxz.y);
    
    // ray direction
    vec3 rd = vec3(pos,1.0); // ray direction to the pixel
    // zoom factor
    rd.xy /= zoom;
    
    // from mouse
    float pitch = mouse.y*PI*.5; // -PI/2 to +PI/2
    float yaw = mouse.x*PI * iResolution.y/iResolution.x; // -PI to +PI
    //float roll = 0.;//PI*.25; //time * .1;
    rd.yz *= rot(pitch); // pitch
    rd.xz *= rot(yaw); // yaw
	//rd.xy *= rot(roll); // roll
    
    // from orientation
    //float opitch = -.125*PI;
    float opitch = -atan(cos(angm)*m*ampy/(rad*k));
    float oyaw = -angy;
    //float oroll = 0.;
    rd.yz *= rot(opitch);
    rd.xz *= rot(oyaw);
    //rd.xy *= rot(oroll);

     // normalized ray direction for the marching, unnormalized for the sky gradient
    vec3 nrd = normalize(rd);
    //rs += rc * -7.0; // - distance to lookat
       
    // ray march for color
    bool hit; // did hit something
    vec3 marchcol = march(rs,nrd,hit);
    

    
    // cursor color
    vec3 circlecolor = keycolor;
    // is inside circle
    vec2 del =  pos - mouse;
    float d2 = dot(del,del);
    float cursrad = 1.0/30.0;
    bool iscursor = d2<cursrad*cursrad;
    
    // sky plane color
    //rs -= nrd * 2.3;
    //rs.z += nrd.z;
    // raycast a plane to infinity
    vec3 skyplanecolor = skyPlane(rs,rd,planeaxis); // do this with an unnormalized ray
   
    
    // put it all together
    vec3 comp;
    if (iscursor)
        comp = circlecolor;
    else if (hit)
		comp = marchcol;
	else
        comp = skyplanecolor;
	gl_FragColor = vec4(comp,1.0);
}
